<?php

// db.php - Conexão com o Banco de Dados
require_once 'config.php'; // Inclui suas credenciais de DB

$conn = null;
try {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        throw new Exception("Falha na conexão com o banco de dados: " . $conn->connect_error);
    }
    // Define o charset para evitar problemas de codificação
    $conn->set_charset("utf8mb4");
} catch (Exception $e) {
    error_log("ERRO FATAL DE DB: " . $e->getMessage());
    // Em um ambiente de produção, você pode querer retornar um erro 500 aqui
    // http_response_code(500);
    // die('Erro interno do servidor.');
}

?>