<?php
/**
 * fb_validate.php
 * Valida User‑Token longo + acesso à página
 * Atualizado: 19/06/2025  (Graph API v19.0)
 *
 * Execute:  php fb_validate.php
 */

const APP_ID          = '570218186143869';
const APP_SECRET      = 'c8a0c8b5b6015ae66eb99577dde4f8de';
const USER_LONG_TOKEN = 'EAAIGnERtZBH0BO7le3BUR0Sf3si5dGOxaDMypDk2MAWAJpsPTSH3YtCo4lHfPMxDZBADz63j3M4chFYNBRCMgonICucvuIAJJ8HOF5vx5apwRgXTZAAZAuZCNKEi88oHtqNyJfgwZAnTAXFcdU0AzM7ZBNGDwZCnnlvCqa1CKnEFuHM5vljtK6eIBWeMnVBiBRlJxwyufmeDYp0AeKxvlGs5u1qSOcJTjySvukAvsHmuvK2AXDZCBc7LogTz2ZCgyxNQZDZD';
const PAGE_ID         = '107018730989128';

/////////////////////// FUNÇÃO DE REQUISIÇÃO ///////////////////////
function fbRequest(string $method, string $endpoint, array $params = [])
{
    $url = 'https://graph.facebook.com/v19.0'.$endpoint;
    $ch  = curl_init();

    if ($method === 'GET') {
        $url .= '?'.http_build_query($params);
    } else {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    }

    curl_setopt_array($ch, [
        CURLOPT_URL            => $url,
        CURLOPT_CUSTOMREQUEST  => $method,
        CURLOPT_RETURNTRANSFER => true,
    ]);

    $resp = curl_exec($ch);
    if (!$resp) {
        throw new RuntimeException('cURL error: '.curl_error($ch));
    }
    curl_close($ch);

    $data = json_decode($resp, true);
    if (isset($data['error'])) {
        $e = $data['error'];
        throw new RuntimeException("Graph error {$e['code']}: {$e['message']}");
    }
    return $data;
}
function logStep(string $txt) { echo PHP_EOL."👉 {$txt}".PHP_EOL; }

////////////////////////////////////////////////////////////////////
// 1) VALIDAR O TOKEN
////////////////////////////////////////////////////////////////////
try {
    logStep('Validando USER_LONG_TOKEN em /debug_token…');
    $debug = fbRequest('GET', '/debug_token', [
        'input_token' => USER_LONG_TOKEN,
        'access_token'=> APP_ID.'|'.APP_SECRET,   // app‑token
    ]);

    echo 'Token válido?      '.($debug['data']['is_valid'] ? 'SIM' : 'NÃO').PHP_EOL;
    echo 'Expira em:         '.date('d/m/Y H:i', $debug['data']['expires_at']).PHP_EOL;
    echo 'Permissões lidas:  '.implode(', ', $debug['data']['scopes']).PHP_EOL;

    ////////////////////////////////////////////////////////////////////
    // 2) VERIFICAR A PÁGINA
    ////////////////////////////////////////////////////////////////////
    logStep('Consultando /me/accounts…');
    $accounts = fbRequest('GET', '/me/accounts', [
        'access_token' => USER_LONG_TOKEN,
        'fields'       => 'id,name,access_token',
    ]);

    if (empty($accounts['data'])) {
        exit("❌ Nenhuma página visível com esse token. Gere outro e SELECIONE a página no pop‑up.\n");
    }

    $found = false;
    foreach ($accounts['data'] as $p) {
        if ($p['id'] === PAGE_ID) {
            $found = true;
            echo PHP_EOL.'🎯 Página localizada: '.$p['name'].' (ID '.$p['id'].')'.PHP_EOL;
            echo   'Page Access Token:'.PHP_EOL.$p['access_token'].PHP_EOL;
            break;
        }
    }
    if (!$found) {
        echo "⚠️  A página ID ".PAGE_ID." não apareceu em /me/accounts. Verifique permissões.\n";
    }
} catch (Throwable $e) {
    echo 'Erro: '.$e->getMessage().PHP_EOL;
}
